<?php
/*
** Strumie orthophoto korzysta z korzysta z zestawu danych Orthophoto
** zarzdzanego przez urzd Land Information New Zealand. Zdjcia przedstawiaj
** ca powierzchni Nowej Zelandii; wsprzdne zgodne s ze standardem New Zealand
** Map Grid (NZMG), ktry jest unikalnym rozwizaniem, stosowanym tylko w Nowej Zelandii.
**
** Wszystkie zdjcia maj rozdzielczo 2,5m na piksel, z dokadnoci 12,5m.
*/

class orthophoto_stream
{
    // To s wygenerowane dane obrazka PNG, ktre zostan przesane z powrotem do strumienia.
    private $png_data;

    // Na potrzeby funkcji ftell() i metody stream_tell().
    private $data_length;

function stream_open($path, $mode, $options, &$opened_path)
{
    // Strumie tylko do odczytu
    if(preg_match('/[w+a]/', $options)) return false;
    $path = parse_url($path);
    $coordinates = $path['host']; // Nietypowe miejsce na takie dane,
                                  // ale prosz przejrze notatk na kocu punktu.
    if(strlen($coordinates)!=21) return false;
    if(strspn($coordinates, '0123456789')!=21) return false;
    list($northing, $easting, $radius)=sscanf($coordinates, '%07d%07d%07d');

    $full_image_size = ceil($radius*2*100/250);

    $full_image = imagecreate($full_image_size, $full_image_size);
    $black = imagecolorallocate($full_image, 0, 0, 0);
    // Kolor czarny traktujemy jak to dla obszarw nieobjtych map.
    imagefill($full_image, 0, 0, $black);

    $maximum_northing = $northing+$radius;
    $minimum_northing = $northing-$radius;
    $maximum_easting = $easting+$radius;
    $minimum_easting = $easting-$radius;
    $bottommost_tile_northing = floor($minimum_northing/250)*250;
    $topmost_tile_northing = ceil($maximum_northing/250)*250;
    $leftmost_tile_easting = floor($minimum_easting/250)*250;
    $rightmost_tile_easting = ceil($maximum_easting/250)*250;

    for($tile_northing=$bottommost_tile_northing;
        $tile_northing<=$topmost_tile_northing;
        $tile_northing+=250)
    for($tile_easting=$leftmost_tile_easting;
        $tile_easting<=$rightmost_tile_easting;
        $tile_easting+=250)
    {
        $full_image_x = 100*($tile_easting-$minimum_easting)/250;
        $full_image_y = 100*($maximum_northing-$tile_northing)/250;
        $tile_name = sprintf('%07d%07d.png', $tile_northing, $tile_easting);
        if(!file_exists('tiles/'.$tile_name)) continue;
        $tile = imagecreatefrompng('tiles/'.$tile_name);
        imagecopy($full_image, $tile, $full_image_x, $full_image_y, 0, 0, 100, 
                  100);
        imagedestroy($tile);
    }
    ob_start();
    imagepng($full_image);
    imagedestroy($full_image);
    $this->png_data = ob_get_contents();
    ob_end_clean();
    $this->data_length = strlen($this->png_data);
    return true;
}

function stream_close()
{
    $this->png_data = null;
}

function stream_read($bytes)
{
    if(strlen($this->png_data)==0)
        return false;
    $return = substr($this->png_data, 0, $bytes);
    $this->png_data = substr($this->png_data, $bytes);
    return $return;
}

function stream_write(){}

function stream_eof()
{
    return $this->png_data == 0;
}

function stream_tell()
{
    return $this->data_length-strlen($this->png_data);
}

function stream_seek()
{
    return false;
}

function stream_flush()
{
    return false; // adne dane nie s przechowywane.
}

function stream_stat()
{
    return false;
}

}

// Tutaj umieszczamy instrukcj rejestrujc strumie (razem z rejestrowanym strumieniem).
// Dziki temu nie bdziemy musieli pamita o kadorazowym rejestrowaniu strumienia
// przy okazji doczania pliku do projektu.
//
// Taki zabieg zakada jednak, e nigdy nie bdziemy prbowali uy tego samego protokou
// (nzmg) do obsugi innego typu danych.
stream_wrapper_register('nzmg', 'orthophoto_stream');
?>
